<?php

namespace App\Http\Controllers;
use Illuminate\Database\QueryException;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Classe;
use Illuminate\Http\Request;

class ClassController extends Controller
{
    public function show()
    {
        $classes = Classe::all();
        return view('class.classes', compact('classes'));
    }

    public function pdfClassList()
    {
        $classes = Classe::all();

        $pdf = Pdf::loadView('class.pdfClassList', compact('classes'));
        return $pdf->download('class-list.pdf');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'nullable|string',
        ]);

        // Normalize input by removing spaces
        $inputName = preg_replace('/\s+/', '', $request->name);
        $inputCode = $request->code ? preg_replace('/\s+/', '', $request->code) : null;

        // Check for existing name ignoring spaces
        $existingName = Classe::whereRaw('REPLACE(name, " ", "") = ?', [$inputName])->first();
        if ($existingName) {
            return back()->with('error', 'Class name "' . $request->name . '" already exists (ignoring spaces).');
        }

        // Check for existing code ignoring spaces (if provided)
        if ($inputCode) {
            $existingCode = Classe::whereRaw('REPLACE(code, " ", "") = ?', [$inputCode])->first();
            if ($existingCode) {
                return back()->with('error', 'Class code "' . $request->code . '" already exists (ignoring spaces).');
            }
        }

        try {
            $classe = new Classe();
            $classe->name = $request->name;
            $classe->code = $request->code;
            $classe->save();

            return redirect()->back()->with('success', 'Class added successfully.');
        } catch (\Exception $e) {
            return back()->with('error', 'Failed to add class. Error: ' . $e->getMessage());
        }
    }


    public function update($id, Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'nullable|string',
        ]);

        // Normalize input by removing all spaces
        $inputName = preg_replace('/\s+/', '', $request->name);
        $inputCode = $request->code ? preg_replace('/\s+/', '', $request->code) : null;

        // Check if another class (excluding this one) has the same name (ignoring spaces)
        $existingName = Classe::where('id', '!=', $id)
            ->whereRaw('REPLACE(name, " ", "") = ?', [$inputName])
            ->first();
        if ($existingName) {
            return back()->with('error', 'Another class with the name "' . $request->name . '" already exists (ignoring spaces).');
        }

        // Check if another class has the same code (ignoring spaces), if code is given
        if ($inputCode) {
            $existingCode = Classe::where('id', '!=', $id)
                ->whereRaw('REPLACE(code, " ", "") = ?', [$inputCode])
                ->first();
            if ($existingCode) {
                return back()->with('error', 'Another class with the code "' . $request->code . '" already exists (ignoring spaces).');
            }
        }

        // Proceed with update
        $classe = Classe::findOrFail($id);
        $classe->name = $request->name;
        $classe->code = $request->code;
        $classe->save();

        return redirect()->back()->with('success', 'Class updated successfully.');
    }



    /*  public function delete($id)
    {

        $classe = Classe::findOrFail($id);
        $classe->delete();

        return redirect()->back()->with('success', 'Class deleted successfully.');
    } */
}
