<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
     protected $commands = [
        \App\Console\Commands\DeleteOldRecords::class,
        \App\Console\Commands\TestCron::class,
    ];
    protected function schedule(Schedule $schedule): void
    {
        $schedule->command('records:delete-old')->everyMinute();
        $schedule->command('test:cron')->everyMinute();
    }
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');
    }
    

}
